<!doctype html>
<html lang="en">

<head>

    <?= $title_meta ?>

    <!-- choices css -->
    <link href="assets/libs/choices.js/public/assets/styles/choices.min.css" rel="stylesheet" type="text/css" />

    <!-- color picker css -->
    <link rel="stylesheet" href="assets/libs/@simonwep/pickr/themes/classic.min.css" /> <!-- 'classic' theme -->
    <link rel="stylesheet" href="assets/libs/@simonwep/pickr/themes/monolith.min.css" /> <!-- 'monolith' theme -->
    <link rel="stylesheet" href="assets/libs/@simonwep/pickr/themes/nano.min.css" /> <!-- 'nano' theme -->

    <!-- datepicker css -->
    <link rel="stylesheet" href="assets/libs/flatpickr/flatpickr.min.css">

    <?= $this->include('partials/head-css') ?>

</head>

<?= $this->include('partials/body') ?>

<!-- <body data-layout="horizontal"> -->

<!-- Begin page -->
<div id="layout-wrapper">

    <?= $this->include('partials/menu') ?>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <?= $page_title ?>
                <!-- end page title -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Css Switch</h4>
                                <p class="card-title-desc">Here are a few types of switches. </p>
                            </div>
                            <!-- end card header -->
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <h5 class="font-size-14 mb-3">Example switch</h5>
                                        <div>
                                            <input type="checkbox" id="switch1" switch="none" checked />
                                            <label for="switch1" data-on-label="On" data-off-label="Off"></label>

                                            <input type="checkbox" id="switch2" switch="default" checked />
                                            <label for="switch2" data-on-label="" data-off-label=""></label>

                                            <input type="checkbox" id="switch3" switch="bool" checked />
                                            <label for="switch3" data-on-label="Yes" data-off-label="No"></label>

                                            <input type="checkbox" id="switch6" switch="primary" checked />
                                            <label for="switch6" data-on-label="Yes" data-off-label="No"></label>

                                            <input type="checkbox" id="switch4" switch="success" checked />
                                            <label for="switch4" data-on-label="Yes" data-off-label="No"></label>

                                            <input type="checkbox" id="switch7" switch="info" checked />
                                            <label for="switch7" data-on-label="Yes" data-off-label="No"></label>

                                            <input type="checkbox" id="switch5" switch="warning" checked />
                                            <label for="switch5" data-on-label="Yes" data-off-label="No"></label>

                                            <input type="checkbox" id="switch8" switch="danger" checked />
                                            <label for="switch8" data-on-label="Yes" data-off-label="No"></label>

                                            <input type="checkbox" id="switch9" switch="dark" checked />
                                            <label for="switch9" data-on-label="Yes" data-off-label="No"></label>
                                        </div>
                                    </div>
                                    <!-- end col -->

                                    <div class="col-lg-6">
                                        <div class="mt-4 mt-lg-0">
                                            <h5 class="font-size-14 mb-3">Square switch</h5>
                                            <div class="d-flex">
                                                <div class="square-switch">
                                                    <input type="checkbox" id="square-switch1" switch="none" checked />
                                                    <label for="square-switch1" data-on-label="On" data-off-label="Off"></label>
                                                </div>
                                                <div class="square-switch">
                                                    <input type="checkbox" id="square-switch2" switch="info" checked />
                                                    <label for="square-switch2" data-on-label="Yes" data-off-label="No"></label>
                                                </div>
                                                <div class="square-switch">
                                                    <input type="checkbox" id="square-switch3" switch="bool" checked />
                                                    <label for="square-switch3" data-on-label="Yes" data-off-label="No"></label>
                                                </div>
                                                <div class="square-switch">
                                                    <input type="checkbox" id="square-switch4" switch="warning" checked />
                                                    <label for="square-switch4" data-on-label="Yes" data-off-label="No"></label>
                                                </div>
                                                <div class="square-switch">
                                                    <input type="checkbox" id="square-switch5" switch="danger" checked />
                                                    <label for="square-switch5" data-on-label="Yes" data-off-label="No"></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end col -->
                                </div>
                                <!-- end row -->
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Choices</h4>
                                <p class="card-title-desc">Choices.js is a lightweight, configurable select box/text input plugin.</p>
                            </div>
                            <!-- end card header -->

                            <div class="card-body">
                                <div>
                                    <h5 class="font-size-14 mb-3">Single select input Example</h5>

                                    <div class="row">
                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-single-default" class="form-label font-size-13 text-muted">Default</label>
                                                <select class="form-control" data-trigger name="choices-single-default" id="choices-single-default" placeholder="This is a search placeholder">
                                                    <option value="">This is a placeholder</option>
                                                    <option value="Choice 1">Choice 1</option>
                                                    <option value="Choice 2">Choice 2</option>
                                                    <option value="Choice 3">Choice 3</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-single-groups" class="form-label font-size-13 text-muted">Option
                                                    groups</label>
                                                <select class="form-control" data-trigger name="choices-single-groups" id="choices-single-groups">
                                                    <option value="">Choose a city</option>
                                                    <optgroup label="UK">
                                                        <option value="London">London</option>
                                                        <option value="Manchester">Manchester</option>
                                                        <option value="Liverpool">Liverpool</option>
                                                    </optgroup>
                                                    <optgroup label="FR">
                                                        <option value="Paris">Paris</option>
                                                        <option value="Lyon">Lyon</option>
                                                        <option value="Marseille">Marseille</option>
                                                    </optgroup>
                                                    <optgroup label="DE" disabled>
                                                        <option value="Hamburg">Hamburg</option>
                                                        <option value="Munich">Munich</option>
                                                        <option value="Berlin">Berlin</option>
                                                    </optgroup>
                                                    <optgroup label="US">
                                                        <option value="New York">New York</option>
                                                        <option value="Washington" disabled>Washington</option>
                                                        <option value="Michigan">Michigan</option>
                                                    </optgroup>
                                                    <optgroup label="SP">
                                                        <option value="Madrid">Madrid</option>
                                                        <option value="Barcelona">Barcelona</option>
                                                        <option value="Malaga">Malaga</option>
                                                    </optgroup>
                                                    <optgroup label="CA">
                                                        <option value="Montreal">Montreal</option>
                                                        <option value="Toronto">Toronto</option>
                                                        <option value="Vancouver">Vancouver</option>
                                                    </optgroup>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-single-no-search" class="form-label font-size-13 text-muted">Options added
                                                    via config with no search</label>
                                                <select class="form-control" name="choices-single-no-search" id="choices-single-no-search">
                                                    <option value="0">Zero</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-single-no-sorting" class="form-label font-size-13 text-muted">Options added
                                                    via config with no search</label>
                                                <select class="form-control" name="choices-single-no-sorting" id="choices-single-no-sorting">
                                                    <option value="Madrid">Madrid</option>
                                                    <option value="Toronto">Toronto</option>
                                                    <option value="Vancouver">Vancouver</option>
                                                    <option value="London">London</option>
                                                    <option value="Manchester">Manchester</option>
                                                    <option value="Liverpool">Liverpool</option>
                                                    <option value="Paris">Paris</option>
                                                    <option value="Malaga">Malaga</option>
                                                    <option value="Washington" disabled>Washington</option>
                                                    <option value="Lyon">Lyon</option>
                                                    <option value="Marseille">Marseille</option>
                                                    <option value="Hamburg">Hamburg</option>
                                                    <option value="Munich">Munich</option>
                                                    <option value="Barcelona">Barcelona</option>
                                                    <option value="Berlin">Berlin</option>
                                                    <option value="Montreal">Montreal</option>
                                                    <option value="New York">New York</option>
                                                    <option value="Michigan">Michigan</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- end row -->
                                </div>
                                <!-- Single select input Example -->


                                <div class="mt-4">
                                    <h5 class="font-size-14 mb-3">Multiple select input</h5>

                                    <div class="row">
                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-multiple-default" class="form-label font-size-13 text-muted">Default</label>
                                                <select class="form-control" data-trigger name="choices-multiple-default" id="choices-multiple-default" placeholder="This is a placeholder" multiple>
                                                    <option value="Choice 1" selected>Choice 1</option>
                                                    <option value="Choice 2">Choice 2</option>
                                                    <option value="Choice 3">Choice 3</option>
                                                    <option value="Choice 4" disabled>Choice 4</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-multiple-remove-button" class="form-label font-size-13 text-muted">With
                                                    remove button</label>
                                                <select class="form-control" name="choices-multiple-remove-button" id="choices-multiple-remove-button" placeholder="This is a placeholder" multiple>
                                                    <option value="Choice 1" selected>Choice 1</option>
                                                    <option value="Choice 2">Choice 2</option>
                                                    <option value="Choice 3">Choice 3</option>
                                                    <option value="Choice 4">Choice 4</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-multiple-groups" class="form-label font-size-13 text-muted">Option
                                                    groups</label>
                                                <select class="form-control" name="choices-multiple-groups" id="choices-multiple-groups" placeholder="This is a placeholder" multiple>
                                                    <option value="">Choose a city</option>
                                                    <optgroup label="UK">
                                                        <option value="London">London</option>
                                                        <option value="Manchester">Manchester</option>
                                                        <option value="Liverpool">Liverpool</option>
                                                    </optgroup>
                                                    <optgroup label="FR">
                                                        <option value="Paris">Paris</option>
                                                        <option value="Lyon">Lyon</option>
                                                        <option value="Marseille">Marseille</option>
                                                    </optgroup>
                                                    <optgroup label="DE" disabled>
                                                        <option value="Hamburg">Hamburg</option>
                                                        <option value="Munich">Munich</option>
                                                        <option value="Berlin">Berlin</option>
                                                    </optgroup>
                                                    <optgroup label="US">
                                                        <option value="New York">New York</option>
                                                        <option value="Washington" disabled>Washington</option>
                                                        <option value="Michigan">Michigan</option>
                                                    </optgroup>
                                                    <optgroup label="SP">
                                                        <option value="Madrid">Madrid</option>
                                                        <option value="Barcelona">Barcelona</option>
                                                        <option value="Malaga">Malaga</option>
                                                    </optgroup>
                                                    <optgroup label="CA">
                                                        <option value="Montreal">Montreal</option>
                                                        <option value="Toronto">Toronto</option>
                                                        <option value="Vancouver">Vancouver</option>
                                                    </optgroup>
                                                </select>
                                            </div>
                                        </div>

                                    </div>
                                    <!-- end row -->
                                </div>
                                <!-- multi select input Example -->

                                <div class="mt-4">
                                    <h5 class="font-size-14 mb-3">Text inputs</h5>

                                    <div class="row">
                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-text-remove-button" class="form-label font-size-13 text-muted">Limited to 5
                                                    values with remove button</label>
                                                <input class="form-control" id="choices-text-remove-button" type="text" value="Task-1,Task-2" placeholder="Enter something" />
                                            </div>
                                        </div>
                                        <!-- end col -->

                                        <div class="col-lg-4 col-md-6">
                                            <div class="mb-3">
                                                <label for="choices-text-unique-values" class="form-label font-size-13 text-muted">Unique values
                                                    only, no pasting</label>
                                                <input class="form-control" id="choices-text-unique-values" type="text" value="Project-A, Project-B" placeholder="This is a placeholder" class="custom class" />
                                            </div>
                                        </div>
                                        <!-- end col -->
                                    </div>
                                    <!-- end row -->

                                    <div>
                                        <label for="choices-text-disabled" class="form-label font-size-13 text-muted">Disabled</label>
                                        <input class="form-control" id="choices-text-disabled" type="text" value="josh@joshuajohnson.co.uk, joe@bloggs.co.uk" placeholder="This is a placeholder" />
                                    </div>
                                </div>
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Colorpicker</h4>
                                <p class="card-title-desc">Flat, Simple, Hackable Color-Picker.</p>
                            </div>
                            <div class="card-body">

                                <div class="text-center">
                                    <div class="row">
                                        <div class="col-lg-4">
                                            <div class="mt-4">
                                                <h5 class="font-size-14">Classic Demo</h5>
                                                <div class="classic-colorpicker"></div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="mt-4">
                                                <h5 class="font-size-14">Monolith Demo</h5>
                                                <div class="monolith-colorpicker"></div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="mt-4">
                                                <h5 class="font-size-14">Nano Demo</h5>
                                                <div class="nano-colorpicker"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->

                <div class="row">
                    <div class="col-lg-12">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Datepicker</h4>
                                <p class="card-title-desc">flatpickr is a lightweight and powerful datetime picker.</p>
                            </div>
                            <div class="card-body">

                                <form action="#">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label class="form-label">Basic</label>
                                                <input type="text" class="form-control" id="datepicker-basic">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">DateTime</label>
                                                <input type="text" class="form-control" id="datepicker-datetime">
                                            </div>
                                            <div class="mb-3">
                                                <label class="form-label">Human-friendly Dates</label>
                                                <input type="text" class="form-control flatpickr-input" id="datepicker-humanfd">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">MinDate and MaxDate</label>
                                                <input type="text" class="form-control" id="datepicker-minmax">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Disabling dates</label>
                                                <input type="text" class="form-control" id="datepicker-disable">
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Selecting multiple dates</label>
                                                <input type="text" class="form-control" id="datepicker-multiple">
                                            </div>

                                            <div>
                                                <label class="form-label">Range</label>
                                                <input type="text" class="form-control" id="datepicker-range">
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="mt-3 mt-lg-0">
                                                <div class="mb-3">
                                                    <label class="form-label">Timepicker</label>
                                                    <input type="text" class="form-control" id="datepicker-timepicker">
                                                </div>

                                                <div>
                                                    <label class="form-label">Inline</label>
                                                    <input type="text" class="form-control" id="datepicker-inline">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!-- end card body -->
                        </div>
                        <!-- end card -->
                    </div>
                    <!-- end col -->
                </div>
                <!-- end row -->

            </div> <!-- container-fluid -->
        </div>
        <!-- End Page-content -->


        <?= $this->include('partials/footer') ?>
    </div>
    <!-- end main content-->

</div>
<!-- END layout-wrapper -->


<?= $this->include('partials/right-sidebar') ?>

<!-- JAVASCRIPT -->
<?= $this->include('partials/vendor-scripts') ?>

<!-- choices js -->
<script src="assets/libs/choices.js/public/assets/scripts/choices.min.js"></script>

<!-- color picker js -->
<script src="assets/libs/@simonwep/pickr/pickr.min.js"></script>
<script src="assets/libs/@simonwep/pickr/pickr.es5.min.js"></script>

<!-- datepicker js -->
<script src="assets/libs/flatpickr/flatpickr.min.js"></script>

<!-- init js -->
<script src="assets/js/pages/form-advanced.init.js"></script>

<script src="assets/js/app.js"></script>

</body>

</html>